//
//  Software for MSP430 based e-meters.
//
//  THIS PROGRAM IS PROVIDED "AS IS". TI MAKES NO WARRANTIES OR
//  REPRESENTATIONS, EITHER EXPRESS, IMPLIED OR STATUTORY,
//  INCLUDING ANY IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS
//  FOR A PARTICULAR PURPOSE, LACK OF VIRUSES, ACCURACY OR
//  COMPLETENESS OF RESPONSES, RESULTS AND LACK OF NEGLIGENCE.
//  TI DISCLAIMS ANY WARRANTY OF TITLE, QUIET ENJOYMENT, QUIET
//  POSSESSION, AND NON-INFRINGEMENT OF ANY THIRD PARTY
//  INTELLECTUAL PROPERTY RIGHTS WITH REGARD TO THE PROGRAM OR
//  YOUR USE OF THE PROGRAM.
//
//  IN NO EVENT SHALL TI BE LIABLE FOR ANY SPECIAL, INCIDENTAL,
//  CONSEQUENTIAL OR INDIRECT DAMAGES, HOWEVER CAUSED, ON ANY
//  THEORY OF LIABILITY AND WHETHER OR NOT TI HAS BEEN ADVISED
//  OF THE POSSIBILITY OF SUCH DAMAGES, ARISING IN ANY WAY OUT
//  OF THIS AGREEMENT, THE PROGRAM, OR YOUR USE OF THE PROGRAM.
//  EXCLUDED DAMAGES INCLUDE, BUT ARE NOT LIMITED TO, COST OF
//  REMOVAL OR REINSTALLATION, COMPUTER TIME, LABOR COSTS, LOSS
//  OF GOODWILL, LOSS OF PROFITS, LOSS OF SAVINGS, OR LOSS OF
//  USE OR INTERRUPTION OF BUSINESS. IN NO EVENT WILL TI'S
//  AGGREGATE LIABILITY UNDER THIS AGREEMENT OR ARISING OUT OF
//  YOUR USE OF THE PROGRAM EXCEED FIVE HUNDRED DOLLARS
//  (U.S.$500).
//
//  Unless otherwise stated, the Program written and copyrighted
//  by Texas Instruments is distributed as "freeware".  You may,
//  only under TI's copyright in the Program, use and modify the
//  Program without any charge or restriction.  You may
//  distribute to third parties, provided that you transfer a
//  copy of this license to the third party and the third party
//  agrees to these terms by its first use of the Program. You
//  must reproduce the copyright notice and any other legend of
//  ownership on each copy or partial copy, of the Program.
//
//  You acknowledge and agree that the Program contains
//  copyrighted material, trade secrets and other TI proprietary
//  information and is protected by copyright laws,
//  international copyright treaties, and trade secret laws, as
//  well as other intellectual property laws.  To protect TI's
//  rights in the Program, you agree not to decompile, reverse
//  engineer, disassemble or otherwise translate any object code
//  versions of the Program to a human-readable form.  You agree
//  that in no event will you alter, remove or destroy any
//  copyright notice included in the Program.  TI reserves all
//  rights not specifically granted under this license. Except
//  as specifically provided herein, nothing in this agreement
//  shall be construed as conferring by implication, estoppel,
//  or otherwise, upon you, any license or other right under any
//  TI patents, copyrights or trade secrets.
//
//  You may not use the Program in non-TI devices.

//******************************************************************************

#ifndef _EMETER_VAR_H
#define _EMETER_VAR_H
#include <stdint.h>


#define PROCESSING 0x22
#define DONE       0x33


union fenr
{
	  struct _PHASE 
	  {
	  	uint32_t Frequency[4];
	  	int32_t PF[4];
	  	uint32_t V_rms[4];
		uint32_t V_RY_rms,V_YB_rms,V_BR_rms/*,Vpp_rms*/;
		uint32_t I_rms[4];
		uint32_t I_neutral;
		int32_t P_Active[4];
		int32_t P_Reactive[4];
		int32_t P_Apparent[4];
		uint32_t act_import[4];
		uint32_t act_export[4];
		uint32_t React_lag[4];
		uint32_t React_lead[4];
		uint32_t apparent[4];
		
		uint32_t Rising_Demand;
		uint32_t Real_Date;
		uint32_t Real_Time;
		uint32_t Max_Demand;
		uint32_t Md_Date;
		uint32_t Md_Time;

		uint32_t Ph_angle[3];
		uint32_t Volt_Unbalance;
		uint32_t Current_Unbalance;
		uint32_t Eng_Quadrant;
		//uint32_t V_thd[3];
		//uint32_t I_thd[3];


	 }Phase;
 unsigned char enr[256];//256
};
extern union fenr f_en;

union fenr_peak
{
	  struct _PHASE_peak
	  {
		  uint32_t V_rms_max[3];		//12
		  uint32_t V_rms_min[3];		//12
		  uint32_t I_rms_max[3];		//12
		  uint32_t I_rms_min[3];		//12
		  int32_t PF_max[4];          	//16
		  int32_t PF_min[4];          	//16
		  uint32_t Frequency_max;    	//4
		  uint32_t Frequency_min;    	//4
		  int32_t Sys_P_Active_max;		//4
		  int32_t Sys_P_Active_min;		//4
		  int32_t Sys_P_Reactive_max;	//4
		  int32_t Sys_P_Reactive_min;	//4
		  int32_t Sys_P_Apparent_max;	//4
		  int32_t Sys_P_Apparent_min;	//4
	 }Phase_peak;
 unsigned char enr_peak[112];
};
extern union fenr_peak f_en_peak;



union fenr1
{
	  struct _PHASE1
	  {
           uint32_t V_harm[24];
		   uint32_t I_harm[24];
    }Phase1;
 unsigned char enr1[192];
};
 extern union fenr1 f_en1;

 union fenr2
 {
 	  struct _PHASE2
 	  {
 		 uint32_t Pow_Off_Date;
 		 uint32_t Pow_Off_Time;
 		 uint32_t Pow_On_Date;
 		 uint32_t Pow_On_Time;
     }Phase2;
  unsigned char enr2[16];
 };
  extern union fenr2 f_en2;

  union fenr3
   {
   	  struct _PHASE3
   	  {
   		 uint32_t Day_act_import;
   		 uint32_t Day_act_export;
   		 uint32_t Day_React_import;
   		 uint32_t Day_React_export;
   		 uint32_t Day_apparent;
   		 
       }Phase3;
    unsigned char enr3[20];
   };
    extern union fenr3 f_en3;


union Fpara
{
	struct powerpara
	{
		float Frequency[4];						//16	1
		float PF[4];							//16	3
		float V_rms[4];							//16	11
		float V_RY_rms,V_YB_rms,V_BR_rms/*,Vpp_rms*/;//12	19
		float I_rms[4];							//16	25
		float I_neutral;						//4
		float P_Active[4];						//16
		float P_Reactive[4];					//16
		float P_Apparent[4];					//16
		float act_import[4];					//16
		float act_export[4];					//16
		float React_lag[4];						//16
		float React_lead[4];					//16
		float apparent[4];						//16
		
		float Rising_Demand;				     //4
		float Real_Date;					     //4
		float Real_Time;					     //4
		float Max_Demand;					     //4
		float Md_Date;						     //4
		float Md_Time;						     //4

		float Ph_angle[3];                       //12
		float Volt_Unbalance;                    //4
		float Current_Unbalance;                 //4
		float Eng_Quadrant;                      //4
	   // float V_thd[3];						    //12
		//float I_thd[3];                         //12

   }en;
 unsigned char f_enr[256];
};
extern union Fpara fp;

union Fpara_peak
{
	struct powerpara_peak
	{
		  float V_rms_max[3];			//12
		  float V_rms_min[3];			//12
		  float I_rms_max[3];			//12
		  float I_rms_min[3];			//12
		  float PF_max[4];          	//16
		  float PF_min[4];          	//16
		  float Frequency_max;    		//4
		  float Frequency_min;    		//4
		  float Sys_P_Active_max;		//4
		  float Sys_P_Active_min;		//4
		  float Sys_P_Reactive_max;		//4
		  float Sys_P_Reactive_min;		//4
		  float Sys_P_Apparent_max;		//4
		  float Sys_P_Apparent_min;		//4
   }en_peak;
 unsigned char f_enr_peak[112];
};
extern union Fpara_peak fp_peak;


union Mbus
{
	struct _MBUSPARA
	{
		float Sys_Frequency;					//4	1
		float V_rms[4];							//16	11
		float I_rms[4];							//16	25
		float Sys_P_Active;						//4
		float Sys_P_Reactive;					//4
		float Sys_P_Apparent;					//4
		float Sys_act_import;					//4
		float Sys_act_export;						//4
		float Sys_React_lag;					//4
		float Sys_React_lead;					//4
		float Sys_apparent;						//4
	}Mbuspara;
 unsigned char mb_f[68];
};
extern union Mbus Mb;

union Mbus_long
{
	struct Mbus_para_l
	{
		uint32_t Sys_Frequency;					//4	1
		uint32_t V_rms[4];							//16	11
		uint32_t I_rms[4];							//16	25
		int32_t Sys_P_Active;						//4
		int32_t Sys_P_Reactive;					//4
		int32_t Sys_P_Apparent;					//4
		uint32_t Sys_act_import;					//4
		uint32_t Sys_act_export;						//4
		uint32_t Sys_React_lag;					//4
		uint32_t Sys_React_lead;					//4
		uint32_t Sys_apparent;						//4
	}Mbuspara_l;
 unsigned char mb_long[68];
};
extern union Mbus_long Mb_l;

union Fpara1
{
	struct powerpara1
	{
        float V_harm[24];
		float I_harm[24];
    }en1;
  unsigned char f_enr1[192];
 };
extern union Fpara1 fp1;

union Fpara2
{
	struct powerpara2
	{
		float Pow_Off_Date;
		float Pow_Off_Time;
		float Pow_On_Date;
		float Pow_On_Time;
    }en2;
  unsigned char f_enr2[16];
 };
extern union Fpara2 fp2;

union Fpara3
{
	struct powerpara3
	{
		float Day_act_import;
		float Day_act_export;
		float Day_React_import;
		float Day_React_export;
		float Day_apparent;
		
    }en3;
  unsigned char f_enr3[20];
 };
extern union Fpara3 fp3;


extern signed char Sign[4];
extern signed char CapInd[4];

typedef struct _CALIB_FACTOR{
  float V_Scale;
  float I_Scale;
  float P_Scale;
  float Q_Scale;
  float P_Scale_low;
  float Q_Scale_low;
} Calib_Factor;


typedef struct _CALIB_PPV{
  float V_RY_Scale;
  float V_YB_Scale;
  float V_BR_Scale;
} CALIB_PPV;	

typedef struct _CALIB_PC{
	unsigned int SD16_Preload[3];
             } CALIB_PC;
struct power_factor
{
	float voltage[4];
	float current[4];
	float  power[4];
	float  SinPF[4];
	float repower[4];
	float aprtpower[4];
};
extern struct power_factor PF;


union para
{
	struct var
	{
		 unsigned int PSWD               ;	   // configuration parameters	//100
		 unsigned int SLAVE_ADDRESS      ;							//101
		 unsigned int baud               ;							//102
		 unsigned int power		     ;								//103
		 unsigned int system 	    ;								//104
		 int pf_type[4];		 	 								//105, 106, 107, 108,
		 unsigned int ct_mbusratio[2];//long ctpt[2]	     ;		//109, 110
		 unsigned int pt_mbusratio[2];								//111, 112
		 unsigned int Vrated  ;										//113
		 unsigned int Irated  ;										//114
		 unsigned int plsconstant	;								//115
		 unsigned int parity	;									//116
		 unsigned int stop_bit	;									//117
		 int unit3;													//118
		 int unit4;													//119
		 unsigned int type		     ;								//120
		
	     unsigned int demand_type;   // KW or KVA 						//121
		 unsigned int Dem_method;   // SLIDING or BLOCK					//122
		 unsigned int Int_time;   // 15 or 30  (only integer values)	//123	
		 unsigned int Sub_int_time;   // 1 to 60  (only integer values)	//124
		 unsigned int Real_sec_min;   // HHMM must be betn 0000 & 5959	//125
		 unsigned int Real_hour_date; // HHMM must be betn 0001 & 2331	//126
		 unsigned int Real_month_year; // HHMM must be betn 0100 & 1299	//127
		 unsigned int Dummy1;											//128
		 unsigned int Dummy2;	//Used For Reset WRite Only				//129

//		
//		// for relay o/p
//		 unsigned int Relay_time     ;								//125
//		 unsigned int power_type     ;								//126
//		 long Set_power              ;								//127
//		 unsigned int demand_unit   ;								//128
//		 //for second pulse o/p	
//		 
//		 int power1;												//129
//		 int plsconstant1;											//130
//		 int analog_sel[4];											//131
//		 unsigned int freq_range_low;
//		 unsigned int freq_range_high;
//		 unsigned int PF_range;
//		 unsigned int volt_range;
//		 unsigned int current_range;
//		 unsigned int Act_pwr_range;
//		 unsigned int React_pwr_range;
//		 unsigned int Apprt_pwr_range;
		 long  ctr;
         long ptr;
	}p;
   unsigned char CONFIG[68];
 };
extern union para pm; 

union pwmcal
{
	struct calpara
	{
	 unsigned int CALconstant[8];
	 int Flag_calib;	//40209  95
	}c;
	char CALB[18];
};
extern union pwmcal cl;

struct bits 
{
  	unsigned char key1_hit : 1;
  	unsigned char key1_rel : 1;
	unsigned char key2_hit : 1;
  	unsigned char key2_rel : 1;
  	unsigned char key3_hit : 1;
  	unsigned char key3_rel : 1;
  	unsigned char key4_hit : 1;
  	unsigned char key4_rel : 1;
  	unsigned char run_mode : 1;	
  	unsigned char password_check : 1;
	unsigned char program_mode : 1;	
	unsigned char blink : 1;
	unsigned char edit : 1;
	unsigned char reset_reg_mode : 1;
	unsigned char calib_mode : 1;
	unsigned char disp : 1;
	unsigned char freez : 1;
	unsigned char start : 1;
	unsigned char sampling_done : 1;
	unsigned char zero_cross_detect : 1;
	unsigned char temp_bit : 1;
	unsigned char sec_blink : 1;
	unsigned char Store_energy : 1;
	unsigned char rx_enable : 1;
	unsigned char pow_on : 1;
	unsigned char bl_mode : 1;
};
extern struct bits b;

union Hrs
{
	struct hours_para
	{
		unsigned int hour;
	 	unsigned char min;
	 	unsigned char sec;
	}HOUR;
	float Hours_data;
};
extern union Hrs ON,LOAD,IDLE,LOAD_IMP,LOAD_EXP;


union Hrs2
{
	struct hours_para2
	{
		unsigned int on_h;
	 	unsigned int on_m;
	 	unsigned int load_h;
	 	unsigned int load_m;
	 	unsigned int idle_h;
	 	unsigned int idle_m;
	 	unsigned int P_intr_cnt;
	 	unsigned int imp_load_h;
		unsigned int imp_load_m;
		unsigned int exp_load_h;
		unsigned int exp_load_m;
		
	}data;
	unsigned char array[22];
};
extern union Hrs2 hours;

union ovcnt
{
	struct cnt_para
	{
		unsigned int whi_m;
		unsigned int whe_m;
		unsigned int vari_m;
		unsigned int vare_m;
		unsigned int va_m;
	}data1;
	unsigned char array1[10];
};
extern union ovcnt ene_cnt;

extern unsigned char sec, sec_load;
//extern unsigned char store_kwh_imp[3];
//extern unsigned char store_kwh_exp[3];
//extern unsigned char store_kvarh_lag[3];
//extern unsigned char store_kvarh_lead[3];
//extern unsigned char store_kvah[3];
//
//extern float pls_act_import[4];
//extern float pls_act_export[4];
//extern float pls_React_lag[4];
//extern float pls_React_lead[4];
//extern float pls_apparent[4];
//extern unsigned char disp[40];
extern unsigned char array_lc[385];
extern double uniterngy_act_import[4];			//16
extern double uniterngy_act_export[4];			//16
extern double uniterngy_React_lag[4];			//16
extern double uniterngy_React_lead[4];			//16
extern double uniterngy_apparent[4];           //16

extern float temp_scale1[3],temp_scale;

extern float temp_pf[3],angle[3],ang_diff[3];
extern int pcb_bit[3];

extern float day_act_imp;
extern float day_act_exp;
extern float day_React_lag;
extern float day_React_lead;
extern float day_apparent;
extern float cntr_act_imp;
extern float cntr_act_exp;
extern float cntr_React_lag;
extern float cntr_React_lead;
extern float cntr_apparent;
extern unsigned char max_min_cal_wait,pow_on_display;

#define SAMPLES_PER_10_SECONDS		40960
extern unsigned int Frequency_meas[3];
extern unsigned char tx_byte,mbus_Frame_Recieved, rx_byte, f_err_crc, F_prg, init_delay;
extern unsigned char slv_buf[5];
extern unsigned char slave_id_changed,old_id;
extern unsigned char F_baud,F_baud_reply,F_parity,parity_reply,F_stopbit,stopbit_reply;//F_baud_changed,old_baud;//F_id, F_id_reply,F_baud_reply, F_PWM,, flag_change_ao
//extern unsigned int cfg_val[36],temp1_baud,PWM_cal[8],count_diff[4],range[4];
//extern unsigned long Enr_val[10];
extern float Ctr,Ptr,CT_MUL_PT;
extern unsigned char NXT,PROG,INC,DEC;
extern unsigned int sec_2_tmr;
extern unsigned char sec_2;
extern unsigned char eng_cntr;
extern unsigned char eng_cnt;
extern unsigned char quadrant;
extern unsigned char disp[11];
//extern double Ctr;
//extern double Ptr;
//extern unsigned int ao_range;
extern unsigned int time_gap,timer0_prev_val;
extern unsigned char byte_counter;
extern unsigned int whi_ovcnt,whe_ovcnt,vari_ovcnt,vare_ovcnt,va_ovcnt;
extern unsigned char check_rtc_cntr;
//extern long Ao_count,PWM_count[4];
extern char ser;
extern int I_low;
extern long delta_value;
extern float EnergyPerPulse1;//,EnergyPerPulse2;
//extern unsigned long EnergyPerPulse;

extern unsigned char percentage_load[3];
extern unsigned char rx_byte_timeout;
//extern PHASE Phase[4];
extern unsigned int Sample_Count,total_freq_range;
//extern unsigned int count_ms1,st_eng;
extern int32_t V_Calc_Sum_R,V_Calc_Sum_B,V_Calc_Sum_Y,I_Calc_Sum_R,I_Calc_Sum_B,I_Calc_Sum_Y, VI_Calc_Sum_R, VI_Calc_Sum_B, VI_Calc_Sum_Y,I_Raw[3];
//extern unsigned long MD_KW_Sum,MD_KW;
//extern unsigned int MD_Sec_Count,MD_Reset_Count;
//extern unsigned long Total_Power_Active,Total_Power_Reactive,Total_Power_Apparent;
extern int32_t Total_Energy,Total_REnergy;
//extern unsigned long Average_PF;
extern unsigned long PEnergy_Imp_Constant,PEnergy_Exp_Constant,QEnergy_Cap_Constant,QEnergy_Ind_Constant,SEnergy_Constant;
extern unsigned long P_Imp_Energy,P_Exp_Energy,Q_Ind_Energy,Q_Cap_Energy,S_Energy;
//extern unsigned char ao_select;
extern unsigned char Accumulate_Samples,gain_Calibrate;
extern unsigned int Samples_Per_Second;
extern unsigned char Phase_Reversal_Detected;
extern float act_impenergy[4],act_expenergy[4],React_lagenergy[4],React_leadenergy[4],Apparent_energy[4];

extern unsigned int sample_cntr_RY,sample_cntr_RB,sample_cntr_BR,sample_cnt_RY[70],sample_cnt_RB[70],sample_cnt_BR[70];
extern unsigned int sample_RY_cnted,sample_RB_cnted,sample_BR_cnted;


extern float RY_phase_angle_cos,RY_phase_angle_sin,phase_ang_RY,phase_ang_RY_1,phase_ang_RY_2;
extern float RB_phase_angle_cos,RB_phase_angle_sin,phase_ang_RB,phase_ang_RB_1,phase_ang_RB_2;
extern float BR_phase_angle_cos,BR_phase_angle_sin,phase_ang_BR,phase_ang_BR_1,phase_ang_BR_2;
extern float I_phase_ang_RY_2,I_phase_ang_RB_2;
//extern float act_impenergy_1[4],act_expenergy_1[4],React_lagenergy_1[4],React_leadenergy_1[4],Apparent_energy_1[4];
extern unsigned char In_cnt,Iy_cnt;
extern unsigned char timeout,cnt,bl_timeout;
extern unsigned char run_para;
extern unsigned char debounce_cnt_key4,debounce_cnt_key3,debounce_cnt_key2,debounce_cnt_key1;

extern float V_creep,V_creep_LL;
extern float I_creep;
extern unsigned char scroll,fav_ret_page_time_cnt;
extern unsigned int freez_page;
extern float per_volt[3],max_volt;
extern float per_curr[3],max_curr;
extern float phase_ang[3];
extern float Enery_resolution[3];
extern float Energy_pls[3];

extern unsigned char run_mode_time_out;
extern unsigned char disp_line;


extern unsigned int P_intr;
extern unsigned char SET_MODE;
extern unsigned char START_BANK;
extern unsigned char DEVICE_SELECT;
extern unsigned char LOAD_X_ADDRESS;
extern unsigned char RAM_ADDRESS;

#ifdef RTC_CALENDAR
extern unsigned char p_off_year, p_off_month, p_off_date, p_off_hour, p_off_min, p_off_sec;
extern unsigned char p_on_year, p_on_month, p_on_date, p_on_hour, p_on_min, p_on_sec;
extern unsigned char prev_Date;
#endif

#ifdef FFT
	extern signed int Sample_array[50];
	extern float fft[6][9];
	extern unsigned char phase_fft;
	extern unsigned char max_sample_cnt;
	extern int *ptr_phase;
	extern int16_t V_Sample[3];
 	extern int16_t I_Sample[4];
#endif
extern unsigned char lcd_init_cnt;


extern void delay(unsigned long);
/*
extern void Initlcd(void);    
extern void Wr_lcd_CGRAM(void);
extern void wrlcdcmd(unsigned char cmd);
extern void wr_lcd(char LineNo,char msg[]);
extern void wrlcddata(unsigned char Data); // We can also remove wrchar() and directly use 
extern void wrmsg(char LineNo,char stloc, char msg[]);
extern void filllcd(unsigned char start_loc,char end_loc,char stuff);
extern void LCD_Disp(void);
*/
extern void Run_Mode(void);
//extern void resetallres(void);
extern void Process_RX_Data(void);
extern void setbaud_modbusuart(void);
extern void cal_crc(unsigned char *,int,char);
//extern void float2str(float value, char *data,unsigned char bytes);
extern void Rst_reg_mode(void);
extern void Modbus_Query(unsigned char);
extern void Password_Mode(void);
extern void Program_Mode(void);
extern void store_energy_pulses(void);
extern void On_hour_calculate(void);
extern void Hour_rst(void);
extern void Key_check(void);
extern void display_message(const char *p,unsigned char k);
extern float get_PF_angle(float measurnd);
extern void display_message1(char *p,unsigned char k);
extern void LC_display(void);
extern void max_min_value_measurement(void);
extern void Low_High_value_rst(void);
extern void cal_long_value(void);
//extern unsigned char KEY1_check(void);
//extern unsigned char KEY2_check(void);
//extern unsigned char KEY3_check(void);
//extern unsigned char KEY4_check(void);

#ifdef RTC_CALENDAR
	extern void Read_RTC(unsigned char addr, unsigned char* ptr_data, unsigned char bytes);
	extern void Write_RTC(unsigned char addr, unsigned char* ptr_data, unsigned char bytes);
	extern void Init_RTC(void);
	extern unsigned char BCD_2_DECIMAL(unsigned char BCD);
	extern unsigned char DECIMAL_2_BCD(unsigned char DECIMAL);
	extern void Real_Time_Read(void);
	extern void Calculate_MaxDemand(void);
	extern void MD_rst(void);
    extern void I2C_Delay(void);
#endif
	
extern float I_Gain_4_devide[3];	
extern float V_Gain_4_devide[3],Vpp_Gain_4_devide[3],V_Gain_2_devide[3],Vpp_Gain_2_devide[3];	
extern float VI_Gain_4_devide[3];	
extern unsigned char Dummy_samp[3];
extern unsigned char Dummy[3];

extern unsigned char init_disp,watchdog_byte,timer_1s_flag;


#define  LEAD           2	//2
#define  LAG            1	//1
#define  UNITY          0	
#define LOW_BYTE_ST_ADRS    3
#define HIGH_BYTE_ST_ADRS   2

#define LOW_BYTE_NOS_REGS   5
#define HIGH_BYTE_NOS_REGS  4

#define HIGH_BYTE_REG_VALUE 4
#define LOW_BYTE_REG_VALUE  5

#define	EXCEPTION_CD  2

//#ifdef RTC_CALENDAR
//	#define MB_RD_MAX	 102
//#else
//	#define MB_RD_MAX	 96
//#endif

#define MB_RD_MAX	 120
		
#define MB_RD_MIN	 00

#define MB_PGM_MAX	 128 
#define MB_PGM_MIN	 100

#define MB_CALB_MAX	 209
#define MB_CALB_MIN	 200

//#define MB_PGM_MAX	 143 
//#define MB_PGM_MIN	 100
//
//#define MB_CALB_MAX	 209
//#define MB_CALB_MIN	 200
#define SLV_ID		0                                
#define FN_CD       1
#define BYTE_COUNT  2  


 
#define EMETER_ACTIVE 0x1f
#define EMETER_HIBERNATING 0x2f
#define EMETER_SLOW_MODE 0x3f

extern unsigned char Emeter_State;

#define WAITING_READOUT_COMMAND     0xa0
#define TRANSMIT_INSTANTANEOUS_DATA 0xb0
#define TRANSMIT_EEPROM_DATA        0xc0

extern unsigned char Data_ReadOut_State;
extern uint16_t Data_Readout_Pointer;

#ifdef RADIOCRAFTS_DEMO

extern unsigned char Radiocrafts_Command;
extern unsigned char TX_Data[20];
extern unsigned char rx_seconds;

#endif

#ifdef MEASURE_V_PHASE_2_PHASE
extern int32_t V_RY_Calc_Sum,V_YB_Calc_Sum,V_BR_Calc_Sum;
extern uint32_t V_RY_rms,V_YB_rms,V_BR_rms,V_RYB_rms;
#endif

#ifdef REACT_POWER_BY_HILBERT_TXFM
extern int32_t V90I_Calc_Sum_R,V90I_Calc_Sum_Y,V90I_Calc_Sum_B;
#endif

#endif


